-- 日志前缀
local LOG_PREFIX = "[BetterWeapon] \n"
local VERSION = "1.0.0.0"

local wukong = nil
local obj = nil

local startCheckFlag = false
local checkFlag = false
local shieldFlag = false

local peFlags = { false, false, false, false, false }

-- 时间量
local DELAY = 50           -- 基准短延迟, 单位：ms
local checkInterval = 1000 -- 基准长延迟, 单位：ms

local mul = 1
local startTime = os.time()
local endTime = os.time()

-- 在脚本启动时打开日志文件
local file = io.open("log.txt", "a")
if not file then
    error("Could not open log file.")
end

-- 日志输出函数
local function Log(msg)
    if file then
        file:write(msg .. "\n")
        file:flush()  -- 保证内容被立即写入
    else
        print("Unable to open log file")
    end
end

Log("Starting " .. VERSION)

local function IsNilOrInvalid(obj)
    return obj == nil or (type(obj.IsValid) == "function" and not obj:IsValid())
end

-- 披挂检测
local b = {
    JinGuBang = false,
    SanJianLiangRen = false,
    LangYa = false,
    HunTie = false,
    FeiLong = false,
    TianLong = false,
    name = "Null"
}

local condition = 0
-- Condition:
-- 0: None
-- 1: San Jian Liang Ren Qiang
-- 2: Lang Ya
-- 3: Jin Gu Bang
-- 4: Hong Tie (bug)
-- 5: Fei Long

-- 基础属性
local attr = {
    hpMax = 0.0,
    hpCur = 0.0,
    hpRatio = 0.0,
    mpMax = 0.0,
    mpCur = 0.0,
    mpRatio = 0.0,
    staminaMax = 0.0,
    defBase = 0.0,
    atkBase = 0.0,
    critRateBase = 0.0,
    critMulBase = 0.0,
    dmgDefBase = 0.0,
    peValue = 0.0,
    tenacity = 0.0,
    shield = 0.0
}

-- 修正属性
local modifier = {
    atk = 0.0,
    critRate = 0.0,
    critMul = 0.0,
    dmgDef = 0.0,
    peValue = 0.0
}

local function resetFuc()
    modifier = { atk = 0.0, critRate = 0.0, critMul = 0.0, dmgDef = 0.0, peValue = 0.0 }

    condition = 0

    startCheckFlag = false
    checkFlag = false
    shieldFlag = false

    peFlags = { false, false, false, false, false }

    Log("Modifiers & Flags & Condition are Reseted\n")
end

local function getEquipOrWukong()
    return FindFirstOf("Unit_EquipPreview_Wukong_C") or FindFirstOf("Unit_Player_Wukong_C")
end

local function getwukong()
    if IsNilOrInvalid(wukong) then wukong = FindFirstOf("Unit_Player_Wukong_C") end
    return wukong
end

local function getobj()
    if IsNilOrInvalid(obj) then obj = StaticFindObject("/Script/b1-Managed.Default__BGUFunctionLibraryCS") end
    return obj
end

-- 确保非负
local function ensureNonNegative(value)
    return math.max(0, value)
end

-- 确保不超过上限
local function ensureWithinLimit(value, limit)
    return math.min(value, limit)
end

-- 属性读取函数
-- ExecuteWithDelay(Integer DelayInMilliseconds, LuaFunction Callback)
-- 延迟需为整型
local function GetValues(wukong, obj, delay)
    delay = delay or (DELAY - 25)
    ExecuteWithDelay(delay, function()
        wukong = wukong or getwukong()
        obj = obj or getobj()
        if IsNilOrInvalid(wukong) or IsNilOrInvalid(obj) then
            Log("Invalid data.\n")
            return
        end

        attr = {
            hpMax = obj:GetAttrValue(wukong, 1),
            hpCur = obj:GetAttrValue(wukong, 151),
            mpMax = obj:GetAttrValue(wukong, 2),
            mpCur = obj:GetAttrValue(wukong, 152),
            staminaMax = obj:GetAttrValue(wukong, 8),
            defBase = obj:GetAttrValue(wukong, 104),
            atkBase = obj:GetAttrValue(wukong, 103),
            critRateBase = obj:GetAttrValue(wukong, 111),
            critMulBase = obj:GetAttrValue(wukong, 112),
            dmgDefBase = obj:GetAttrValue(wukong, 120),
            peValue = obj:GetAttrValue(wukong, 191),
            shield = obj:GetAttrValue(wukong, 190),
        }

        if attr.hpMax > 0 then
            attr.hpRatio = attr.hpCur / attr.hpMax
        else
            Log("Invalid data: hpMax <= 0\n")
        end

        if attr.mpMax > 0 then
            attr.mpRatio = attr.mpCur / attr.mpMax
        else
            Log("Invalid data: mpMax <= 0\n")
        end

        return attr
    end)
end

local function logEquip()
    local wukonge = getEquipOrWukong()
    local obj = getobj()
    if IsNilOrInvalid(wukonge) or IsNilOrInvalid(obj) then
        return
    end

    Log(string.format(
        "Equipment: \n %s \n %s \n %s \n %s \n %s",
        wukonge.bodypart_weapon.SkeletalMesh:GetFullName(),
        wukonge.bodypart_head.SkeletalMesh:GetFullName(),
        wukonge.bodypart_upwear.SkeletalMesh:GetFullName(),
        wukonge.bodypart_arm.SkeletalMesh:GetFullName(),
        wukonge.bodypart_foot.SkeletalMesh:GetFullName()
    ))
end

-- 属性设置函数
local function SetValues(wukong, obj, values, delay)
    -- 修正延迟, 单位：ms
    delay = delay or 0
    ExecuteWithDelay(delay, function()
        wukong = wukong or getwukong()
        obj = obj or getobj()
        if IsNilOrInvalid(wukong) or IsNilOrInvalid(obj) then
            Log("Invalid data.\n")
            return
        end

        obj:BGUSetAttrValue(wukong, 103, values.atkBase)
        obj:BGUSetAttrValue(wukong, 153, values.atkBase)
        obj:BGUSetAttrValue(wukong, 111, values.critRateBase)
        obj:BGUSetAttrValue(wukong, 161, values.critRateBase)
        obj:BGUSetAttrValue(wukong, 112, values.critMulBase)
        obj:BGUSetAttrValue(wukong, 162, values.critMulBase)
        obj:BGUSetAttrValue(wukong, 120, values.dmgDefBase)
        obj:BGUSetAttrValue(wukong, 170, values.dmgDefBase)
    end)
end


-- 武器检测
local function checkWeapon(name)
    local wukonge = getEquipOrWukong()

    local wep = wukonge.bodypart_weapon.SkeletalMesh:GetFullName()
    Log("checking weapon: " .. tostring(wep))
    if IsNilOrInvalid(wep) then
        Log("Invalid data: weapon. \n")
        return false
    end
    return wep:find(name) ~= nil
end

-- 如意金箍棒检测
local function bJinGuBang()
    return checkWeapon("DaSheng")
end

-- 三尖两刃枪检测
local function bSanJianLiangRen()
    return checkWeapon("SanJianLiangRen")
end
-- SkeletalMesh /Game/00MainHZ/Characters/Wukong/Meshes/Weapon/SanJianLiangRen/SK_wukong_sanjianliangrenqiang.SK_wukong_sanjianliangrenqiang

-- 狼牙棒检测
local function bLangYa()
    return checkWeapon("LangYaGun01")
end

-- 混铁棍检测
local function bHunTie()
    return checkWeapon("huntiegun")
end

-- 飞龙棍检测
local function bFeiLong()
    return checkWeapon("FeiLongGun01")
end

-- 数值修正函数
local function modifyValues(wukong, obj)
    wukong = wukong or getwukong()
    -- obj = obj or getobj()
    local delayL = DELAY
    GetValues(wukong, obj, delayL)

    logEquip()

    local function resetAttr()
        -- Log(string.format(
        --     "Attributes: \nattr.atkBase: %.4f, attr.critRateBase: %.4f, attr.critMulBase: %.4f, attr.dmgDefBase: %.4f \nModifiers: \nmodifier.atk: %.4f, modifier.critRate: %.4f, modifier.critMul: %.4f, modifier.dmgDef: %.4f \n",
        --     attr.atkBase, attr.critRateBase, attr.critMulBase, attr.dmgDefBase, modifier.atk, modifier.critRate, modifier.critMul, modifier.dmgDef
        -- ))

        attr.atkBase = attr.atkBase - modifier.atk
        attr.critRateBase = attr.critRateBase - modifier.critRate
        attr.critRateBase = ensureNonNegative(attr.critRateBase)
        attr.critMulBase = attr.critMulBase - modifier.critMul
        attr.dmgDefBase = attr.dmgDefBase - modifier.dmgDef

        -- Log(string.format(
        --     "Attributes reseted: \nattr.atkBase: %.4f, attr.critRateBase: %.4f, attr.critMulBase: %.4f, attr.dmgDefBase: %.4f \n",
        --     attr.atkBase, attr.critRateBase, attr.critMulBase, attr.dmgDefBase
        -- ))
    end

    local function getModifiers()
        if b.name == "LangYa" then
            if condition ~= 2 then
                modifier.atk = 40
                modifier.critRate = 2500
            end
        elseif b.name == "SanJianLiangRen" then
            if condition ~= 1 then
                modifier.atk = 0
                modifier.critRate = 1400
            end
        elseif b.name == "JinGuBang" then
            if condition ~= 3 then
                modifier.atk = 0
                modifier.critRate = 1400
            end
        elseif b.name == "HunTie" then
            if condition ~= 4 then
                modifier.atk = 25
                modifier.critRate = 2000
            end
        elseif b.name == "FeiLong" then
            if condition ~= 5 then
                modifier.atk = 27
                modifier.critRate = 2000
            end
        elseif condition == 0 then
            modifier.atk = 0
            modifier.critRate = 0
            modifier.critMul = 0
            modifier.dmgDef = 0
        end
    end

    local function applyModifiers()
        attr.atkBase = attr.atkBase + modifier.atk
        attr.critRateBase = attr.critRateBase + modifier.critRate
        attr.critMulBase = attr.critMulBase + modifier.critMul
        attr.dmgDefBase = attr.dmgDefBase + modifier.dmgDef
    end

    local function logAndSetAttr()
        SetValues(wukong, obj, attr)
    end

    local function modifyAttr()
        if b.name == "LangYa" then
            if condition ~= 2 then
                Log("\nLangYa Weapon\n")
                resetAttr()
                getModifiers()
                applyModifiers()
                logAndSetAttr()
                condition = 2
            end
        elseif b.name == "SanJianLiangRen" then
            if condition ~= 1 then
                Log("\nSanJianLiangRen Weapon\n")
                resetAttr()
                getModifiers()
                applyModifiers()
                logAndSetAttr()
                condition = 1
            end
        elseif b.name == "JinGuBang" then
            if condition ~= 3 then
                Log("\nJinGuBang Weapon\n")
                resetAttr()
                getModifiers()
                applyModifiers()
                logAndSetAttr()
                condition = 3
            end
        elseif b.name == "HunTie" then
            if condition ~= 4 then
                Log("\nHuntie Weapon\n")
                resetAttr()
                getModifiers()
                applyModifiers()
                logAndSetAttr()
                condition = 4
            end
        elseif b.name == "FeiLong" then
            if condition ~= 5 then
                Log("\nFeiLong\n")
                resetAttr()
                getModifiers()
                applyModifiers()
                logAndSetAttr()
                condition = 5
            end
        elseif condition ~= 0 then
            Log("Condition not met\n")
            resetAttr()
            getModifiers()
            -- applyModifiers()
            logAndSetAttr()
            condition = 0
        end
    end

    ExecuteWithDelay(delayL + 5, function()
        if attr.atkBase < 0 then
            Log("Invalid data.\n")
            return
        end
        modifyAttr()
    end)
end

local function checkData()
    if checkFlag then
        local wukong = getwukong()
        local obj = getobj()

        if IsNilOrInvalid(wukong) or IsNilOrInvalid(obj) then
            Log("Invalid data.\n")
            resetFuc()
            return
        end

        b = {
            JinGuBang = bJinGuBang(),
            SanJianLiangRen = bSanJianLiangRen(),
            LangYa = bLangYa(),
            HunTie = bHunTie(),
            FeiLong = bFeiLong()
        }

        if b.LangYa == true then
            b.name = "LangYa"
        elseif b.SanJianLiangRen == true then
            b.name = "SanJianLiangRen"
        elseif b.JinGuBang == true then
            b.name = "JinGuBang"
        elseif b.HunTie == true then
            b.name = "HunTie"
        elseif b.FeiLong == true then
            b.name = "FeiLong"
        else
            b.name = "Null"
        end

        modifyValues(wukong, obj)

        if not startCheckFlag then
            startCheckFlag = true
            Log("Data checke start.\n")
        end
    end
end

local function clock()
    checkFlag = true
    ExecuteWithDelay(checkInterval, function()
        clock()
    end)
end

local function startCheckData()
    clock()
    checkData()
    -- passiveActivate()

    if not startCheckFlag then
        ExecuteWithDelay(checkInterval * 2, function()
            startCheckData()
        end)
    else
        Log("Data check started.\n")
        return true
    end
end

-- 其它可用函数：ClientRestart
RegisterHook("/Script/Engine.PlayerController:ServerAcknowledgePossession", function(self, pawn)
    -- Log("ClientRestarted")
    Log("ServerAcknowledgePossessed\n")

    resetFuc()
    local elapsedTime = endTime - startTime
    ExecuteWithDelay(checkInterval * 25, function()
        wukong = getwukong()
        obj = getobj()

        startCheckData(wukong, obj)
        if IsNilOrInvalid(wukong) or IsNilOrInvalid(obj) then
            Log("Invalid data.\n")
            return
        end

        local checkClock = 500 -- 设置 checkData() 调用间隔. 75 * 0.01 = .75s
        local timer = 0       -- 计时器
        local integer = 0

        -- BlueprintUpdateAnimation ~ 装备页面更新
        RegisterHook("/Script/b1-Managed.BUAnimEquipPreview:BlueprintUpdateAnimation", function(self, delaySec)
            timer = timer + 1
            if timer > checkClock then
                integer = integer + 1
                timer = 0
                checkData()
                endTime = os.time()
                elapsedTime = endTime - startTime
                Log(tostring(integer) .. " : Elapsed time: " .. tostring(elapsedTime) .. " seconds")
            end
        end)
    end)
end)

-- 在程序退出时关闭日志文件
closeLog()